Httpd="/usr/bin/httpd"
SZD_USER_CONF="/etc/httpd/sites-enabled-user"

tmpDir="/root/apache_conf_test"
backupDir="/root/apache_conf_old"
confWhiteList="httpd-vhost.conf-user httpd-ssl-vhost.conf-user"
removeList=""

cleanUp() {
	mv $tmpDir/*.conf $SZD_USER_CONF
	rm -rf $tmpDir
}

echo $1

if $Httpd -t $1; then
	return 0
fi

if ! ls $SZD_USER_CONF/*.conf; then
	return 0
fi

mkdir -p $tmpDir
mkdir -p $backupDir
mv $SZD_USER_CONF/*.conf $tmpDir

# First, we try to determine that httpd conf error is caused by include file or httpd.conf-user problem
# if problem is cause by httpd.conf-user we don't need to check user's conf
for conf in $confWhiteList; do
	[ -f $tmpDir/$conf ] && mv $tmpDir/$conf $SZD_USER_CONF
done
if ! $Httpd -t $1; then
	echo "httpd.conf-user may contain error config"
	cleanUp
	return 0
fi

for conf in `ls $tmpDir/*.conf`; do
	cp $conf $SZD_USER_CONF
	if ! $Httpd -t $1; then
		removeList="$removeList $conf"
		echo $conf result http-user couldn\'t startup, move it the $backupDir
	fi
	rm $SZD_USER_CONF/*.conf
done

if [ -n "$removeList" ]; then
	/usr/syno/bin/synodsmnotify @administrators dsmnotify:system_event service:web_error_config
	/usr/bin/logger -p user.err -t `basename $0` "httpd-user's  sites-enabled-user contains error conf: $removeList"
fi

mv $removeList $backupDir
cleanUp

exit 0
